;;; -*- Mode: Common-Lisp; Package: User; Base: 10.; Patch-File: T -*-
;;; Written 11/21/88 16:04:32 by GRENINGER,
;;; Reason: :mouse-position now interprets a negative mouse button number as a fake mouse click, 
;;; calculates the mouse coordinates to be the origin of the screen's currently selected
;;; window.
;;; while running on MX23 from band TEST
;;; With SYSTEM 5.19, GC 5.3, VIRTUAL-MEMORY 5.5, MICRONET 5.5, MICRONET-COMM 5.13,
;;;  DISK-IO 5.9, BASIC-PATHNAME 5.2, MAC-PATHNAME 5.0, NETWORK-SUPPORT-COLD 5.1,
;;;  BASIC-NAMESPACE 5.6, BASIC-FILE 5.3, RPC 5.4, NFS 5.10, EH 5.3, MAKE-SYSTEM 5.2,
;;;  MEMORY-AUX 5.1, MACTOOLBOX 1.25, COMPILER 5.1, TV 5.20, NVRAM 5.1, UCL 5.0, INPUT-EDITOR 5.0,
;;;  METER 5.0, ZWEI 5.9, DEBUG-TOOLS 5.1, WINDOW-MX 5.27, PRINTER 5.11, MAC-PRINTER-TYPES 5.4,
;;;  NETWORK-PATHNAME 5.0, NETWORK-NAMESPACE 5.0, DATALINK 5.7, CHAOSNET 5.6, NETWORK-SUPPORT 5.0,
;;;  NETWORK-SERVICE 5.0, DATALINK-DISPLAYS 5.0, NAMESPACE-EDITOR 5.1, IP 3.33, NFS-SERVER 5.3,
;;;  PRINTER-TYPES 5.2, IMAGEN 5.1, MAIL-DAEMON 5.1, MAIL-READER 5.3, TELNET 5.1,
;;;  VT100 5.0, STREAMER-TAPE 5.6, DECNET 1.45, VISIDOC 5.4, PROFILE 5.1, DISK-LABEL 5.1,
;;;   microcode 96, Band Name: test #6

#!C
; From file BASIC-COMM-METHODS.LISP#> WINDOW-MX; SYS:
#10R MACINTOSH#:
(COMPILER-LET ((*PACKAGE* (FIND-PACKAGE "MACINTOSH"))
                          (SI:*LISP-MODE* :COMMON-LISP)
                          (*READTABLE* SYS:COMMON-LISP-READTABLE)
                          (SI:*READER-SYMBOL-SUBSTITUTIONS* SYS::*COMMON-LISP-SYMBOL-SUBSTITUTIONS*))
  (COMPILER#:PATCH-SOURCE-FILE "SYS: WINDOW-MX; BASIC-COMM-METHODS.#"


(DEFMETHOD (mac-flavor :mouse-position) ()
  "Returns the X and Y values of the mouse position and a button-event
if one occured.  A button-event has the bit format #b0000 0000 00UT DLMR 
where:
  U = 1 means a mouse button up excursion occured,
  T = 1 means a mouse tripple click occured,
  D = 1 means a mouse double click occured,
  L = 1 means it was a mouse left button,
  M = 1 means it was a mouse middle button,
  R = 1 means it was a mouse right button.
Negative X/Y values indicate special events on the Mac.  The
x-coord and screen id  are converted from the 16-bit positive value 
an art-16b array returns to a 16-bit signed value."
  (DECLARE (SPECIAL si:%driver-data-start))
  (LET ((mouse-x (si:%nubus-read-16b
		   si:*addin-memory-slot*
		   (+ si:%driver-data-start si:%dd-mouse-x)))
	(mouse-y (si:%nubus-read-16b
		   si:*addin-memory-slot*
		   (+ si:%driver-data-start si:%dd-mouse-y)))
	(mouse-screen-id (si:%nubus-read-16b si:*addin-memory-slot*
					     (+ si:%driver-data-start
			                        si:%dd-mouse-screen)))
	(mouse-button (si:%nubus-read-16b
			si:*addin-memory-slot*
			(+ si:%driver-data-start si:%dd-mouse-buffer)))
	(mouse-valid (si:%nubus-read-8b
		       si:*addin-memory-slot*
		       (+ si:%driver-data-start si:%dd-mouse-valid)))
	mouse-screen-descriptor)
    
    (WHEN (> mouse-valid 0)
      (si:%nubus-write-8b si:*addin-memory-slot*
			  (+ si:%driver-data-start si:%dd-mouse-valid)
			  0))
    
    (WHEN (> mouse-x #x7fff)
      (SETF mouse-x (- -1 (LOGXOR mouse-x #xffff))))
    
    (WHEN (> mouse-y #x7fff)			;Added 3/3/87 KED
      (SETF mouse-y (- -1 (LOGXOR mouse-y #xffff))))

    (WHEN (> mouse-screen-id #x7fff)
      (SETF mouse-screen-id (- -1 (LOGXOR mouse-screen-id #xffff))))

    (SETF mouse-screen-descriptor
	  (AREF *mac-resident-explorer-screens* (ABS mouse-screen-id)))
    
    ;;  If mouse-button is negative, then it's a fake mouse click for the screen's selected
    ;;  window.  Calculate mouse coordinates equal to the origin of the screen's selected window,
    ;;  force a single left-click...
    (WHEN (> mouse-button #x7fff)
      (SETF mouse-button 36.)
      (MULTIPLE-VALUE-SETQ (mouse-x mouse-y)
	(tv:sheet-calculate-offsets
	  (the-last-selected-window mouse-screen-descriptor) nil))
      (INCF mouse-x (1- (tv:sheet-width (the-last-selected-window
					  mouse-screen-descriptor))))
      (INCF mouse-y (1- (tv:sheet-height (the-last-selected-window
					  mouse-screen-descriptor)))))
    
    (WHEN (AND (EQ tv:default-screen (the-screen mouse-screen-descriptor))
	       (NEQ tv:default-screen tv:mouse-sheet))
      ;; then we are not changing screens but in order to return mouse coordinates relative to the
      ;; mouse-sheet we must adjust mouse-x and mouse-y for the cumulative offset of
        ;; tv:mouse-sheet relative to the default-screen...
      (MULTIPLE-VALUE-BIND (cumulative-x-offset cumulative-y-offset)
	  (tv:sheet-calculate-offsets tv:mouse-sheet nil)
	(DECF mouse-x cumulative-x-offset)
	(DECF mouse-y cumulative-y-offset)))

    (VALUES
      mouse-x
      mouse-y
      (IF (AND (PLUSP mouse-valid) (PLUSP mouse-button)) mouse-button)
      mouse-screen-id)))
))
